'use client';

import { Header } from '@/components/header';
import HeroSection from '@/components/hero-section';
import { ConsortiumInfo } from '@/components/consortium-info';
import { Footer } from '@/components/footer';
import { AnimatedWrapper } from '@/components/animated-wrapper';
import WhyChooseUs from '@/components/why-choose-us';
import { Partners } from '@/components/partners';
import { useEffect } from 'react';
import CoreSectors from '@/components/core-sectors';
import { ServicesOverview } from '@/components/services-overview';
import { Capabilities } from '@/components/capabilities';
import AboutUsSection from '@/components/about-us-section';
import WhyPartnersChooseUs from '@/components/why-partners-choose-us';
import IsoCertificates from '@/components/iso-certificates';
import { ProjectGallery } from '@/components/project-gallery';

export default function Home() {
  // This is a fix to make the header transparent on the hero section for the home page only
  useEffect(() => {
    document.body.classList.add('is-home');
    return () => {
      document.body.classList.remove('is-home');
    };
  }, []);

  return (
    <div className="flex min-h-screen flex-col bg-background">
      <Header />
      <main className="flex-1">
        <HeroSection />

        <div className="space-y-24 sm:space-y-32">
          <AnimatedWrapper>
            <ConsortiumInfo />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <AboutUsSection />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <ServicesOverview />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <CoreSectors />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <Capabilities />
          </AnimatedWrapper>
           <AnimatedWrapper>
            <ProjectGallery />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <WhyPartnersChooseUs />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <WhyChooseUs />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <IsoCertificates />
          </AnimatedWrapper>
          <AnimatedWrapper>
            <Partners />
          </AnimatedWrapper>
        </div>
      </main>
      <Footer />
    </div>
  );
}
